/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ES6Iterator;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;

public final class NativeArrayIterator
extends ES6Iterator {
    private static final String ITERATOR_TAG = "ArrayIterator";
    private ArrayIteratorType type;
    private Scriptable arrayLike;
    private int index;

    static void init(ScriptableObject scope, boolean sealed) {
        NativeArrayIterator.init(scope, sealed, new NativeArrayIterator(), ITERATOR_TAG);
    }

    private NativeArrayIterator() {
    }

    public NativeArrayIterator(Scriptable scope, Scriptable arrayLike, ArrayIteratorType type) {
        super(scope, ITERATOR_TAG);
        this.index = 0;
        this.arrayLike = arrayLike;
        this.type = type;
    }

    @Override
    public String getClassName() {
        return "Array Iterator";
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        return (long)this.index >= NativeArray.getLengthProperty(cx, this.arrayLike, false);
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        if (this.type == ArrayIteratorType.KEYS) {
            return this.index++;
        }
        Object value = this.arrayLike.get(this.index, this.arrayLike);
        if (value == NOT_FOUND) {
            value = Undefined.instance;
        }
        if (this.type == ArrayIteratorType.ENTRIES) {
            value = cx.newArray(scope, new Object[]{this.index, value});
        }
        ++this.index;
        return value;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }

    public static enum ArrayIteratorType {
        ENTRIES,
        KEYS,
        VALUES;

    }
}

